VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   4095
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   5880
   LinkTopic       =   "Form1"
   ScaleHeight     =   4095
   ScaleWidth      =   5880
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Cairo As New cCairo

Private Sub Form_Load()
  Caption = "Click Me!"
End Sub

Private Sub Form_Click()

  'First we need a Surface, which is a "physical thing" (a real Render-Target)
  Dim Srf As cCairoSurface
  'a Cairo-Image-Surface is something like an allocated InMemory-Bitmap (a hDIB)
  Set Srf = Cairo.CreateSurface(200, 100, ImageSurface)
  
  
  'Ok, now the drawing - to be able to do so, we need a Context first ...
  'and the CC below is something like an hDC in GDI, but ...
  Dim CC As cCairoContext
  'unlike in GDI, where we would "Select" a Bitmap into a hDC first...
  'with Cairo we can create such a CC "anytime" from any Surface
  'in a non-expensive Operation (this does not need larger CPU-cycles)
  Set CC = Srf.CreateContext
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  'before our first rectangle, just a comment about Pixels and Scaling:
  'Cairos Image-Surfaces are "normal Bitmaps" - and in this example we've
  'created a 200x100 Pixel-Surface (with 32Bit ColorDepth) - the initial
  'x/y Scaling-Factors of a new created CairoContext (our CC) are 1 ...
  'and Scale 1 means, that the given Coords work "Pixelbased" (as in GDI)
  CC.Rectangle 10, 10, 180, 80
  'Oh, and the above line has not drawn anything to the Pixel-Surface yet,
  'it is only a Path-Definition ..., so if we want to Fill this Path, we
  'must tell it explicitely - first (yet before the Fill-Command), a Color:
  CC.SetSourceColor vbYellow
  CC.Fill '<-only now the Pixel within our Path are filled and the Surface-Content is changed
  
  'Ok, finally some Textoutput, otherwise it wouldn't be a Hello-World-Demo ;-)
  CC.SelectFont "Times New Roman", 25, vbRed
  CC.TextOut 25, 30, "Hello Cairo"

  
  'and this is our final "beam-up-into-the-Windows-World" ... if we want
  'the Cairo-PixelBuffers (the Surface-Contents) on our Windows-Screen,
  'we have to use the GDI finally - Srf.DrawToDC is internally (stretch-)blitting
  'our "Cairo-Pixels" and expects an hDC-Parameter for that
  Srf.DrawToDC hDC, 20, 20
End Sub

